#ifndef __C_SIMENDPOINT_H
#define __C_SIMENDPOINT_H

#include "Endpoint/cEndpoint.h"
#include <winsock2.h>

/*
 * cSimEndpoint.h
 *
 * Network simulation endpoint.
 */
class cSimEndpoint : public cEndpoint
{
  public:
	friend class cSimNetLayer;	// The simulation layer can access it's members.
	friend class cSimEngine;

	cSimEndpoint();
	cSimEndpoint(unsigned int subnet, unsigned int address);
	~cSimEndpoint();

	unsigned int	HashCode();
	bool Equals(cHashObject* hObj);
	bool LessThan(cHashObject* hObj);
	bool SubnetLessThan(cEndpoint* ep);
	bool IsSameSubnet(cEndpoint* ep);
	cEndpoint* AllocCopy();
	char* Serialize(char* buffer, int *size);
	char* Deserialize(char* buffer, int *size);
	unsigned int GetSize();
	void Print(ostream &errStream);

  private:
	unsigned int	_ComputeHashCode();
	unsigned int	mHashCode;

	unsigned int	mSubnetIndex;
	unsigned int	mAddressIndex;
};

#endif